# Custom Recognition and Action

> Note: This document is about integrating with NodeJS
>
> Note: The returned type of the following registered function can also be Promised, thus you can do async actions inside. Most of actions of Context are async.

## Custom Recognition

```json
{
    "Task": {
        "recognition": "Custom",
        "custom_recognition": "myReco",
        "custom_recognition_param": {
            "msg": "Hello world!"
        },
    }
}
```

```typescript
export interface CustomRecognizerSelf {
    context: Context
    id: maa.TaskId
    name: string
    param: unknown
    image: maa.ImageData
}

res.register_custom_recognizer('myReco', function (this: CustomRecognizerSelf, self: CustomRecognizerSelf) {
    return [
        {
            x: 0,
            y: 0,
            width: 0,
            height: 0
        },
        '111'
    ]
})
```

The following is an exmaple of calling another task to recognize

```typescript
inst.register_custom_recognizer('forward', (self) => {
    return self.context.run_recognition('another_task', self.image)
})
```

## Custom Action

```json
{
    "Task": {
        "action": "Custom",
        "custom_action": "myAct",
        "custom_action_param": {
            "msg": "Hello world!"
        },
    }
}
```

```typescript
interface CustomActionSelf {
    context: Context
    id: maa.TaskId
    name: string
    param: unknown
    box: maa.Rect
    detail: string
}

inst.register_custom_action('myAct', function (this: CustomActionSelf, self: CustomActionSelf) => {
    return true
})
```

The following is an exmaple of calling another task to act

```typescript
inst.register_custom_action('forward', (self) => {
    return self.context.run_action('another_task', box, detail)
})
```
